import discord

from discord.ext import commands

import json

with open("config.json", "r") as f:

    config = json.load(f)

WELCOME_CHANNEL_ID = config["WELCOME_CHANNEL_ID"]

class Welcome(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @commands.Cog.listener()

    async def on_member_join(self, member):

        channel = member.guild.get_channel(WELCOME_CHANNEL_ID)

        if channel:

            embed = discord.Embed(

                title="🎉 Bienvenue !",

                description=f"Bienvenue {member.mention} sur **{member.guild.name}** ! 🎓\nNous sommes ravis de t’accueillir.",

                color=0x7B6AB2

            )

            embed.set_thumbnail(url=member.display_avatar.url)

            await channel.send(embed=embed)

async def setup(bot):

    await bot.add_cog(Welcome(bot))